<div class="tab-pane fade  <?php echo e($route == 'web-backup'?'show active':''); ?>" id="web-backup" role="tabpanel"
    aria-labelledby="web-backup-tab">
    <div class="row p-0 m-0">
        <div class="col-md-12">
            <h4><?php echo app('translator')->get('setting.backup.history'); ?></h4>
            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('app.filename'); ?></th>
                            <th><?php echo app('translator')->get('app.size'); ?></th>
                            <th><?php echo app('translator')->get('app.time'); ?></th>
                            <th><?php echo app('translator')->get('app.action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(count($backups) > 0): ?>
                        <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($backup['filename']); ?></td>
                            <td><?php echo e(ByteConverter::bytesToHuman($backup['size'])); ?></td>
                            <td><?php echo e(date('Y-m-d H:i',$backup['time'])); ?></td>
                            <td>
                                <div class="d-inline-block">
                                    <form
                                        action="<?php echo e(route('admin.settings.backup.db',['name'=> $backup['filename'],'ext'=>$backup['extension']])); ?>"
                                        method="post">
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-info btn-sm"><i class="fa fa-download"></i></button>
                                    </form>
                                </div>
                                <div class="d-inline-block">
                                    <form
                                        action="<?php echo e(route('admin.settings.backup.destroy',['name'=> $backup['filename'],'ext'=>$backup['extension']])); ?>"
                                        method="post">
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr>
                            <td></td>
                            <td></td>
                            <td><i>
                                    <h5><?php echo app('translator')->get('setting.no_record'); ?></h5>
                                </i></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <form action="<?php echo e(route('admin.settings.backup.files')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="<?php echo app('translator')->get('setting.backup.file'); ?>">
                    </form>
                </div>
                <div class="col-md-6">
                    <form action="<?php echo e(route('admin.settings.backup.db')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="submit" class="w-100 mt-2 btn btn-success"
                            value="<?php echo app('translator')->get('setting.backup.database'); ?>">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/admin/settings/tabs/backup.blade.php ENDPATH**/ ?>